/*
 * DMLApplet.java
 *
 * Created on 2006-01-18, 11:20
 */

package ch.hslu.cm.dml;

import ch.hslu.cm.rer.diagram.EntityFigure;
import ch.hslu.cm.rer.diagram.RelationshipFigure;
import ch.hslu.cm.rer.model.RelationalERModel;
import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import org.jhotdraw.app.action.edit.DeleteAction;
import org.jhotdraw.app.action.edit.DuplicateAction;
import org.jhotdraw.app.action.edit.SelectAllAction;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.draw.action.BringToFrontAction;
import org.jhotdraw.draw.action.GroupAction;
import org.jhotdraw.draw.action.SendToBackAction;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.draw.action.UngroupAction;
import org.jhotdraw.draw.event.ToolEvent;
import org.jhotdraw.draw.event.ToolListener;
import org.jhotdraw.draw.tool.ConnectionTool;
import org.jhotdraw.draw.tool.CreationTool;
import org.jhotdraw.draw.tool.DelegationSelectionTool;
import org.jhotdraw.draw.tool.Tool;
import org.jhotdraw.undo.UndoRedoManager;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.*;
/**
 * Applet mit einem Editor für Klassen-Diagramme.
 *
 * @author  wrandels
 */
public class DMLApplet extends JApplet implements ToolListener {
    private final static String VERSION = "0.1";
    private final static String NAME = "ConceptModeler[ER]";
    
    private LinkedList<Action> drawingActions;
    private LinkedList<Action> selectionActions;
    private UndoRedoManager undoManager;
    private DMLDiagram drawing;
    private RelationalERModel simulation;
    private ResourceBundleUtil labels;
    private DrawingEditor drawingEditor;

    @Override
    public void boundsInvalidated(ToolEvent e) {
        //
    }
    
    private class ToolButtonListener implements ItemListener {
        private Tool tool;
        public ToolButtonListener(Tool t) {
            this.tool = t;
        }
        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getStateChange() == ItemEvent.SELECTED) {
                setTool(tool);
            }
        }
    }
    
    
    
    /**
     * Initializes the applet DMLApplet
     */
    @Override
    public void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (Throwable e) {
            // Do nothing.
            // If we can't set the desired look and feel, UIManager does
            // automaticaly the right thing for us.
        }
        Container c = getContentPane();
        c.setLayout(new BoxLayout(c, BoxLayout.Y_AXIS));
        for (StringTokenizer tt = new StringTokenizer(getAppletInfo(), "\n"); tt.hasMoreTokens(); ) {
            c.add(new JLabel(tt.nextToken()));
        }
        
        new Worker() {
            @Override
            public Object construct() {
                Object result;
                
                labels = ResourceBundleUtil.getBundle("ch.hslu.cm.er.Labels", getLocale());
                
                try {
                    if (getParameter("data") != null) {
                        NanoXMLDOMInput domi = new NanoXMLDOMInput(new DMLModelFactory(), new StringReader(getParameter("data")));
                        domi.openElement("ConceptModelerER");
                        result = domi.readObject(0);
                    } else if (getParameter("datafile") != null) {
                        InputStream in = null;
                        try {
                            URL url = new URL(getDocumentBase(), getParameter("datafile"));
                            in = url.openConnection().getInputStream();
                            NanoXMLDOMInput domi = new NanoXMLDOMInput(new DMLModelFactory(), in);
                            domi.openElement("ConceptModelerER");
                            result = domi.readObject(0);
                            result = domi.readObject(1);
    System.out.println("result: "+result);                        
                        } finally {
                            if (in != null) in.close();
                        }
                    } else {
                        result = null;
                    }
                } catch (Throwable t) {
                    result = t;
                }
                return result;
            }
            @Override
            public void finished() {
                Container c = getContentPane();
                c.setLayout(new BorderLayout());
                c.removeAll();
                
                Object result = getValue();
                initComponents();
                if (result != null && (result instanceof Drawing)) {
                    drawing = (DMLDiagram) result;
                } else {
                    drawing = new DMLDiagram();
                }
                drawingView.setDrawing(drawing);
                undoManager = new UndoRedoManager();
                drawing.addUndoableEditListener(undoManager);
                initTools();
                
                if (result != null && (result instanceof Throwable)) {
                    drawing.add(new TextFigure(result.toString()));
                }
                c.validate();
            }
        }.start();
    }
    @Override
    public String getAppletInfo() {
        return NAME+"\nVersion "+VERSION
        +"\n\nCopyright 2006 \u00a9 Lucerne University of Applied Sciences and Arts"
        +"\nAlle Rechte vorbehalten."
        +"\n\nDiese Software basiert auf"
        +"\nJHotDraw \u00a9 1999-2008 by the original authors of JHotDraw and all its contributors."
        +"\nNanoXML \u00a9 2000-2002 Marc De Scheemaecker";
    }
    
    private void initTools() {
        
        Tool selectionTool = new DelegationSelectionTool(getDrawingActions(), getSelectionActions());
        drawingEditor.setTool(selectionTool);
        selectionToolButton.addItemListener(
        new ToolButtonListener(selectionTool)
        );
        
        initCreationTools();
    }
    private void initCreationTools() {
        HashMap<AttributeKey,Object> attributes;
        RelationshipFigure ac;
        
        attributes = new HashMap<AttributeKey,Object>();
        attributes.put(AttributeKeys.FILL_COLOR, DMLDiagram.ENTITY_TYPE_NAME_COMPARTMENT_COLOR);
        attributes.put(AttributeKeys.STROKE_COLOR, DMLDiagram.ENTITY_TYPE_STROKE_COLOR);
        attributes.put(AttributeKeys.TEXT_COLOR, DMLDiagram.ENTITY_TYPE_TEXT_COLOR);
        entityTypeToolButton.addItemListener(
        new ToolButtonListener(new CreationTool(new EntityFigure(), attributes))
        );
        attributes = new HashMap<AttributeKey,Object>();
        attributes.put(AttributeKeys.FILL_COLOR, DMLDiagram.RELATION_FILL_COLOR);
        attributes.put(AttributeKeys.STROKE_COLOR, DMLDiagram.RELATION_STROKE_COLOR);
        ac = new RelationshipFigure();
        ac.getModel().setStartCardinality(1);
        ac.getModel().setEndCardinality(1);
        relation11ToolButton.addItemListener(
        new ToolButtonListener(new ConnectionTool(ac, attributes))
        );
        ac = new RelationshipFigure();
        ac.getModel().setStartCardinality(1);
        ac.getModel().setEndCardinality(-1);
        relation1MToolButton.addItemListener(
        new ToolButtonListener(new ConnectionTool(ac, attributes))
        );
        ac = new RelationshipFigure();
        ac.getModel().setStartCardinality(-1);
        ac.getModel().setEndCardinality(-1);
        relationMMToolButton.addItemListener(
        new ToolButtonListener(new ConnectionTool(ac, attributes))
        );
    }
    public void setData(String text) {
        drawing.removeAllChildren();
        if (text != null && text.length() > 0) {
            StringReader in = new StringReader(text);
            try {
                undoManager.discardAllEdits();
                NanoXMLDOMInput domi = new NanoXMLDOMInput(new DMLModelFactory(), in);
                domi.openElement("ConceptModelerER");
                
                final RelationalERModel ermodel;
                final DMLDiagram erdiagram;
                
                ermodel = (RelationalERModel) domi.readObject(0);
                erdiagram = (DMLDiagram) domi.readObject(1);
                
                erdiagram.putSimulation(ermodel);
                drawing = erdiagram;
                simulation = ermodel;
                drawingEditor.getActiveView().setDrawing(erdiagram);
                drawing.addUndoableEditListener(undoManager);
            } catch (Throwable e) {
                drawing.removeAllChildren();
                TextFigure tf = new TextFigure();
                tf.setText(e.getMessage());
                tf.setBounds(new Point2D.Double(10,10), new Point2D.Double(100,100));
                drawing.add(tf);
                e.printStackTrace();
            } finally {
                if (in != null) in.close();
            }
        }
    }
    public String getData() {
        CharArrayWriter out = new CharArrayWriter();
        try {
            NanoXMLDOMOutput domo = new NanoXMLDOMOutput(new DMLModelFactory());
            domo.openElement("ConceptModelerER");
            domo.writeObject(simulation);
            domo.writeObject(drawing);
            domo.closeElement();
            domo.save(out);
        } catch (IOException e) {
            TextFigure tf = new TextFigure();
            tf.setText(e.getMessage());
            tf.setBounds(new Point2D.Double(10,10), new Point2D.Double(100,100));
            drawing.add(tf);
            e.printStackTrace();
        } finally {
            if (out != null) out.close();
        }
        return out.toString();
    }
    private Collection<Action> getDrawingActions() {
        if (drawingActions == null) {
            drawingActions = new LinkedList<Action>();
            drawingActions.add(undoManager.getUndoAction());
            drawingActions.add(undoManager.getRedoAction());
            drawingActions.add(null); // separator
            drawingActions.add(new SelectAllAction());
        }
        return drawingActions;
    }
    private Collection<Action> getSelectionActions() {
        if (selectionActions == null) {
            selectionActions = new LinkedList<Action>();
            selectionActions.add(new DuplicateAction());
            selectionActions.add(new DeleteAction());
            selectionActions.add(null); // separator
            selectionActions.add(new GroupAction(drawingEditor));
            selectionActions.add(new UngroupAction(drawingEditor));
            selectionActions.add(null); // separator
            selectionActions.add(new BringToFrontAction(drawingEditor));
            selectionActions.add(new SendToBackAction(drawingEditor));
        }
        return selectionActions;
    }
    
    public void setTool(Tool newTool) {
        Tool oldTool = drawingEditor.getTool();
        if (oldTool != null && oldTool != newTool) {
            oldTool.removeToolListener(this);
        }
        drawingEditor.setTool(newTool);
        if (newTool != null) {
            newTool.addToolListener(this);
        }
    }
    
    @Override
    public void areaInvalidated(ToolEvent e) {
        // Empty
    }
    
    @Override
    public void toolDone(ToolEvent event) {
        selectionToolButton.setSelected(true);
    }
    
    @Override
    public String[][] getParameterInfo() {
        return new String[][] {
            { "data", "String", "the data to be displayed by this applet." },
            { "datafile", "URL", "an URL to the data to be displayed by this applet." }
        };
    }

    @Override
    public void toolStarted(ToolEvent event) {
    }
    
    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        toolGroup = new javax.swing.ButtonGroup();
        jToolBar1 = new javax.swing.JToolBar();
        selectionToolButton = new javax.swing.JToggleButton();
        entityTypeToolButton = new javax.swing.JToggleButton();
        relation11ToolButton = new javax.swing.JToggleButton();
        relation1MToolButton = new javax.swing.JToggleButton();
        relationMMToolButton = new javax.swing.JToggleButton();
        scrollPane = new javax.swing.JScrollPane();
        drawingView = new org.jhotdraw.draw.DefaultDrawingView();

        jToolBar1.setFloatable(false);
        toolGroup.add(selectionToolButton);
        selectionToolButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/ch/randelshofer/draw/images/tool_select.png")));
        selectionToolButton.setSelected(true);
        selectionToolButton.setToolTipText(labels.getString("selectAndMove"));
        jToolBar1.add(selectionToolButton);

        toolGroup.add(entityTypeToolButton);
        entityTypeToolButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/ch/hslu/cm/er/images/tool_entityType.png")));
        entityTypeToolButton.setToolTipText(labels.getString("entityType"));
        jToolBar1.add(entityTypeToolButton);

        toolGroup.add(relation11ToolButton);
        relation11ToolButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/ch/hslu/cm/er/images/tool_relation11.png")));
        relation11ToolButton.setToolTipText(labels.getString("relation11"));
        jToolBar1.add(relation11ToolButton);

        toolGroup.add(relation1MToolButton);
        relation1MToolButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/ch/hslu/cm/er/images/tool_relation1M.png")));
        relation1MToolButton.setToolTipText(labels.getString("relation1M"));
        jToolBar1.add(relation1MToolButton);

        toolGroup.add(relationMMToolButton);
        relationMMToolButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/ch/hslu/cm/er/images/tool_relationMM.png")));
        relationMMToolButton.setToolTipText(labels.getString("relationMM"));
        jToolBar1.add(relationMMToolButton);

        getContentPane().add(jToolBar1, java.awt.BorderLayout.SOUTH);

        scrollPane.setViewportView(drawingView);

        getContentPane().add(scrollPane, java.awt.BorderLayout.CENTER);

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private org.jhotdraw.draw.DefaultDrawingView drawingView;
    private javax.swing.JToggleButton entityTypeToolButton;
    private javax.swing.JToolBar jToolBar1;
    private javax.swing.JToggleButton relation11ToolButton;
    private javax.swing.JToggleButton relation1MToolButton;
    private javax.swing.JToggleButton relationMMToolButton;
    private javax.swing.JScrollPane scrollPane;
    private javax.swing.JToggleButton selectionToolButton;
    private javax.swing.ButtonGroup toolGroup;
    // End of variables declaration//GEN-END:variables
    
}
